/*
 * Decompiled with CFR 0.152.
 */
package adql.db;

public class DBType {
    public static final int NO_LENGTH = -1;
    public final DBDatatype type;
    public final int length;

    public DBType(DBDatatype dBDatatype) {
        this(dBDatatype, -1);
    }

    public DBType(DBDatatype dBDatatype, int n) {
        if (dBDatatype == null) {
            throw new NullPointerException("Missing TAP column datatype !");
        }
        this.type = dBDatatype;
        this.length = n;
    }

    public boolean isNumeric() {
        switch (this.type) {
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case REAL: 
            case DOUBLE: 
            case BINARY: 
            case VARBINARY: 
            case BLOB: {
                return true;
            }
        }
        return false;
    }

    public boolean isBinary() {
        switch (this.type) {
            case BINARY: 
            case VARBINARY: 
            case BLOB: {
                return true;
            }
        }
        return false;
    }

    public boolean isString() {
        switch (this.type) {
            case CHAR: 
            case VARCHAR: 
            case CLOB: 
            case TIMESTAMP: {
                return true;
            }
        }
        return false;
    }

    public boolean isGeometry() {
        return this.type == DBDatatype.POINT || this.type == DBDatatype.REGION;
    }

    public boolean isCompatible(DBType dBType) {
        if (dBType == null) {
            return false;
        }
        if (this.isBinary() == dBType.isBinary()) {
            return this.type == DBDatatype.BLOB && dBType.type == DBDatatype.BLOB || this.type != DBDatatype.BLOB && dBType.type != DBDatatype.BLOB;
        }
        if (this.isNumeric() == dBType.isNumeric()) {
            return true;
        }
        if (this.isGeometry() == dBType.isGeometry()) {
            return this.type == dBType.type;
        }
        if (this.isString()) {
            return this.type == DBDatatype.CLOB && dBType.type == DBDatatype.CLOB || this.type != DBDatatype.CLOB && dBType.type != DBDatatype.CLOB;
        }
        return this.type == dBType.type;
    }

    public String toString() {
        if (this.length > 0) {
            return (Object)((Object)this.type) + "(" + this.length + ")";
        }
        return this.type.toString();
    }

    public static enum DBDatatype {
        SMALLINT,
        INTEGER,
        BIGINT,
        REAL,
        DOUBLE,
        BINARY,
        VARBINARY,
        CHAR,
        VARCHAR,
        BLOB,
        CLOB,
        TIMESTAMP,
        POINT,
        REGION;

    }
}

